Version 1 of Adaptive Hints by Michael Martin begins here.

"An adaptive hint system inspired by Eric Eve's extension of the same name."

Include Menus by Emily Short.

To activate (hintname - a table-name):
	if the hintname is a subtable listed in the Table of Potential Hints:
		choose a row with a subtable of hintname in the Table of Potential Hints;
		if the active entry is 0:
			if the turn count is greater than zero:
				now the active entry is the turn count;
			otherwise:
				now the active entry is 32767.

To deactivate (hintname - a table-name):
	if the hintname is a subtable listed in the Table of Potential Hints:
		choose a row with a subtable of hintname in the Table of Potential Hints;
		now the active entry is -1.

To reinstate (hintname - a table-name):
	if the hintname is a subtable listed in the Table of Potential Hints:
		choose a row with a subtable of hintname in the Table of Potential Hints;
		now the active entry is 0;
		activate hintname.

To construct the hints menu:
	repeat through the Table of Active Hints:
		blank out the whole row;
	sort the Table of Potential Hints in active order;
	let index be 1;
	repeat with N running from 1 to the number of rows in the Table of Potential Hints:
		choose row N in the Table of Potential Hints;
		if there is a title entry and there is an active entry and the active entry is greater than zero:
			let h_title be the title entry;
			let h_subtable be the subtable entry;
			choose row index in the Table of Active Hints;
			now the title entry is h_title;
			now the subtable entry is h_subtable;
			now the toggle entry is hint toggle rule;
			increase index by 1;
	choose row index in the Table of Active Hints;
	now the title entry is "Previous Menu";
	now the toggle entry is the quit rule.

Table of Active Hints 
title	subtable	description	toggle
text	table-name	text	a rule
with 20 blank rows

Table of Potential Hints 
title	subtable	active
text	table-name	a number

Before displaying, construct the hints menu.

Adaptive Hints ends here.

---- DOCUMENTATION ----

Note: This documentation is lifted directly from Eric Eve's template, and needs to be rewritten.

Emily Short's Menus extension includes a mechanism for showing hints, but provides only for static hint menus. In many cases we may want our hint system to adapt to the situation in the game, showing only those hints that are currently relevant.

For example, it may be premature to display a series of hints on "How do I extract the golden egg from the glass goose?" until the player knows that there are such objects as the golden egg and the glass goose. Conversely there is no point in continuing to display this hint once the player has solved the golden egg puzzle. The Adaptive Hints extension builds on Emily Short's Menus extension to allow the author to activate and deactivate hints as appropriate.

To set up a system of adaptive hints, we first need to supply a table of hints for each hint topic, as in the Tabulation example that comes with the Menus extension. For example we might create hint tables like:

	Table of Golden Egg Hints
	hint															used
	"How might you get an object out of a closed glass container?"	a number
	"You can't just smash the glass goose, because you might never get it back together again,
	and Professor Gosling asked you to bring it back in one piece."
	"Maybe you could cut the glass with something?"
	"It would have to be something sharp and hard."
	"Have you wondered what you might do with that diamond?"
	
Then, to use the Adaptative Hints extension, we need to define a pair of table continuations to contain, first the hints that are going to come into play later in our game, and second, the currently active hints. The first of these tables must be called "The Table of Potential Hints (continued)" and contains three columns, "title", "subtable", and "active":

	Table of Potential Hints (continued)
	title													subtable		active
	"How do I extract the golden egg from the glass goose?"	Table of Golden Egg Hints		0
	"How do I unlock the lead door?"						Table of Lead Door Hints		0
	"How do I get past the deranged ostrich?"				Table of Ostrich Hints		0
	
The second table, "The Table of Active Hints", is defined in the extension, and allows for up to twenty hints to be active at once. If we need more than this we can define a continuation table, which must be called "The Table of Active Hints (continued)" and must contain four columns: "title", "subtable", "description", "toggle". This table must contain enough blank rows to accommodate the maximum number of hints that may be active at any one time. For example, if we think that we may have a maximum of thirty hints active at some point in our game, we shall need to define a continuation table with an extra 10 rows:

	Table of Active Hints (continued)
	title	subtable		description	toggle
	text	table-name		text		a rule
	with 10 blank rows

On the other hand, if we are sure there will never be more than twenty hints active at once, we need not define this continuation table at all.	
	
We next need some mechanism for activating and deactivating hints as required. To this end we can simply use "activate {Table Name}" or "deactivate {Table Name}" as required; for example:

	activate the Table of Golden Egg Hints.
	deactivate the Table of Ostrich Hints.
	
These phrases modify the appropriate "active" entry.  Active entries set to 1 at initialization are available from the start of play.  Once deactivated, a hint will not be reactivated by the "activate" command. Instead, use:

	reinstate the Table of Ostrich Hints.
	  
During play, it may be more convenient to watch for conditions that require hints to be activated or deactivated rather than adding activate and deactivate phrases to action responses. Unlike the hint activation rules and hint deactivation rules in Eric Eve's extension, this extension uses scenes to duplicate the effect:

	Eggstravaganza is a scene.  Eggstravaganza begins when the Goose Vault is visited.  Eggstravaganza ends when the golden egg is handled.

	When Eggstravaganza begins, activate the Table of Golden Egg Hints.

	When Eggstravaganza ends, deactivate the Table of Golden Egg Hints.

To display your hints, carry out the displaying activity with the Table of Active Hints, or provide it as a subtable in your own code.
	
	
Example: ** Escape from an Old House - A short game with several adaptive hints, adapted from Eric Eve's example.

	*: "Escape from an Old House" by Eric Eve and Michael Martin

	Include Adaptive Hints by Michael Martin.

	Part 1 - Hint Tables

	Table of Potential Hints (continued)
	title	subtable		active
	"What should I do now?"	Table of General Hints	1
	"What can I do in the Hall?"	Table of Hall Hints	0
	"What should I do in the Lounge?"	Table of Lounge Hints	0
	"How do I open the front door?"	Table of Front Door Hints	0
	"How do I unlock the tall cabinet?"	Table of Cabinet Hints	0
	"How can I get through the window?"	Table of Window Hints	0
	"How do I unlock the front door?"	Table of Iron Key Hints	0

	Table of General Hints
	hint	used
	"Try exploring a bit."	a number
	"Then trying exploring a bit more."
	"Have you explored enough yet?"

	Table of Lounge Hints
	hint	used
	"Look around."
	"But frankly there's not much here."
	"Except that mouldy old carpet."

	Table of Hall Hints
	hint	used
	"Search it thoroughly."
	"What did you find?"
	"Perhaps that tall cabinet is worth investigating."

	Table of Cabinet Hints
	hint	used
	"Obviously, you need to find a key."
	"Maybe it's been dropped somewhere."
	"Somewhere not that obvious."
	"And maybe it slid under something."
	"Like a carpet."

	Table of Front Door Hints
	hint	used
	"Well, finding the key wouild be a start."
	"It may not be far from the front door"
	"Have you tried looking in the cabinet?"
	"What did you find there?"

	Table of Iron Key Hints
	hint	used
	"What did you find in the hall cabinet?"
	"How thoroughly have you examined it?"
	"Did it have a pocket?"
	"What was in the pocket?"

	Table of Window Hints
 	hint	used	
	"Forget it"
	"There's no way you're going to get through that window."

	Exploration is a scene. Exploration begins when play begins. Exploration ends when the number of visited rooms is the number of rooms - 1.
	When Exploration ends, deactivate the Table of General Hints.

	The Shadow Cabinet is a scene. The Shadow Cabinet begins when play begins. The Shadow Cabinet ends when the tall cabinet is open.
	When Shadow Cabinet ends:
	  deactivate the Table of Cabinet Hints;
	  deactivate the Table of Hall Hints;
	  deactivate the Table of Front Door Hints;
	  activate the Table of Iron Key Hints.

	Iron Will is a scene. Iron Will begins when play begins. Iron Will ends when the iron key is seen.
	When Iron Will ends:
	  deactivate the Table of Window Hints;
	  deactivate the Table of Iron Key Hints.

	Brass Will is a scene. Brass Will begins when play begins. Brass Will ends when the brass key is seen.
	When Brass Will ends:
	  deactivate the Table of Lounge Hints.

	Lounge Visitation is a scene. Lounge Visitation begins when play begins. Lounge Visitation ends when the lounge is visited.
	When Lounge Visitation ends, activate the Table of Lounge Hints.

	Hall Visitation is a scene. Hall Visitation begins when play begins. Hall Visitation ends when the hall is visited.
	When Hall Visitation ends, activate the Table of Hall Hints.

	Window to the Soul is a scene. Window to the Soul begins when play begins. Window to the Soul ends when the window is seen.
	When Window to the Soul ends:
	  activate the Table of Window Hints.

	Asking for help is an action out of world. Understand "help" or "hint" or "hints" as asking for help.
	Carry out asking for help:
	  change the current menu to the Table of Active Hints;
	  carry out the displaying activity;
	  clear the screen;
	  say paragraph break;
	  say paragraph break;
	  try looking.

	Part 2 - Game World

	Chapter 1 - Setup

	Use full-length room descriptions.

	After printing the banner text when the turn count is 1:
	say "[line break]You woke up this morning to find yourself trapped in this creepy old house. Now you just want to get out."

	Every thing is either seen or unseen. A thing is usually unseen.

	Before printing the name of a thing (called the item):
	Now the item is seen.

	Carry out examining something (called the item):
	Now the item is seen.

	The maximum score is 4.

	Chapter 2 - The Map

	Section 1 - The Drawing Room

	The Drawing Room is a room. "A window overlooks the drive to the north, but unfortunately it is solidly barred and there seems to be no way to open it. But you could go south to the lounge or east to the hall."

	The barred window is scenery in the drawing room. The description is "You can see through it onto the drive, but there seems to be no way you could open it, and even if you could the bars would prevent your cliimbing through." Understand "bars" as the window.

	Instead of entering or opening the window:
  	now the window is seen;
	say "The bars prevent you."

	Instead of attacking the window: 
	now the window is seen;
	say "Beating your bare fists against the bars proves painful and unproductive."

	Section 2 - The Lounge

	The Lounge is a room. "A mouldy carpet covers most of the floor all the way up to the archway leading into the drawing room to the north."

	The mouldy carpet is scenery in the lounge. The description is "Worn and woven in muddy colours, this carpet was probably new when Horatio Nelson was still a midshipman."

	Instead of looking under the mouldy carpet for the first time:
	Now the brass key is carried by the player;
	award 1 point;
	say "You turn up one corner of the carpet after another, and your fourth attempt you find a small brass key, which you duly take."

	Instead of looking under the mouldy carpet:
	say "You find nothing more but dust."

	The plain archway is a door. It is south of the Drawing Room and north of the Lounge. It is scenery, open and unopenable. The description is "Rather plain, it nevertheless just about serves to separate the drawing room and lounge into two separate areas."

	Section 3 - The Hall

	The Hall is east of the Drawing Room.
	"Large enough to count as pretentious, the hall stretches towards a heavy front door to the north. A broad staircase leads up to the first floor, while the drawing room lies to the west."

	The tall wooden cabinet is here. "A tall wooden cabinet stands proudly against the wall." The cabinet is a container. It is openable, closed, lockable, locked and fixed in place. The description is "You're no expert on antique furniture, but you'd judge this to be a regency piece." Understand "regency" or "antique" or "furniture" as the tall wooden cabinet.

	The small brass key unlocks the tall wooden cabinet.

	Before opening the tall wooden cabinet when the cabinet is locked:
	activate the Table of Cabinet Hints.

	The old trench coat is in the cabinet. "An old trench coat hangs in the cabinet". It is wearable. The description is "It looks battered enough to have been through the Battle of the Somme. It does have one pocket still intact however."

	The pocket is part of the coat. It is an unopenable open container. Understand "coat pocket" as the pocket.

	Instead of searching the coat, try searching the pocket.

	In the pocket is a large iron key. The description of the iron key is "It looks just the job for unlocking a large, heavy door."

	The solid front door is a door. It is north of the hall and south of the drive. The description is "It's made of thick, solid oak. There's clearly going to be no way through it without opening it, and it's current [if open]open[otherwise]firmly closed[end if]." It is closed, scenery, lockable and locked. The large iron key unlocks the front door.

	Before opening the front door when the front door is locked:
	activate the Table of Front Door Hints.

	The drive is a room. After going to the drive:
	say "At last, you're out of that wretched house!";
  	award 3 points;
  	end the game in victory.

	The staircase is a door. The staircase is above the Hall and below the Landing. It is scenery, open and unopenable. Understand "stairs" as the staircase.

	Instead of climbing the staircase: try entering the staircase.

	Section  4 - The Landing

	The Landing is a room. "This long landing runs between many bedrooms, all of which you have searched thoroughly already. A staircase leads back down to the hall."

	Instead of going nowhere from the landing, say "You've already searched thoroughly up here, and in any case the only way out of this wretched house is surely downstairs."

	Chapter 3 - Testing
 
	test first with "Open window/break window/e/n/open door/climb the stairs/n/d/open the cabinet"

	test second with "w/s/look under the carpet/n/e/unlock the cabinet/open it/look in cabinet"

	test third with "take coat/wear it/x it/look in pocket/unlock door with iron key/open door/n"

	test me with "test first/test second/test third"

Note that although this test runs through the game to completion, it doesn't of itself demonstrate the hint system. For that you need to run through the game manually and try out the hints every few turns to see how they change.
